function guiWithTwoPushbuttons
% guiWithTwoPushbuttons has two pushbuttons, each
%   of which has a separate callback function
% Format: guiWithTwoPushbuttons
 
% Create the GUI but make it invisible for now while 
%  it is being initialized
f = figure('Visible', 'off','color','white','Units',...
    'Normalized', 'Position', [.25 .5 .4 .2]);
f.Name = 'GUI with 2 pushbuttons';
movegui(f,'center')
 
% Create a pushbutton that says "Push me!!"
hbutton1 = uicontrol('Style','pushbutton','String',...
    'Push me!!', 'Units', 'Normalized',...
    'Position',[.3 .6 .4 .2], ...
    'Callback',@callbackfn1);
 
% Create a pushbutton that says "No, Push me!!"
hbutton2 = uicontrol('Style','pushbutton','String',...
    'No, Push me!!', 'Units', 'Normalized',...
    'Position',[.3 .3 .4 .2], ...
    'Callback',@callbackfn2);
% Now the GUI is made visible
f.Visible = 'on';
 
    % Call back function for first button
    function callbackfn1(hObject,eventdata)
       % callbackfn is called by the 'Callback' property
       % in the first pushbutton 

        set([hbutton1 hbutton2],'Visible','off');
        hstr = uicontrol('Style','text',...
            'BackgroundColor', 'white', 'Units',...
            'Normalized','Position',[.4 .5 .2 .2],...
            'String','!!!!!', ...
            'ForegroundColor','Red','FontSize',30);
        hstr.Visible = 'on';
    end
 
    % Call back function for second button
    function callbackfn2(hObject,eventdata)
       % callbackfn is called by the 'Callback' property
       % in the second pushbutton

        set([hbutton1 hbutton2],'Visible','off');
        hstr = uicontrol('Style','text',...
            'BackgroundColor','white', 'Units', ...
            'Normalized', 'Position',[.4 .5 .2 .2],...
            'String','*****', ...
            'ForegroundColor','Blue','FontSize',30);
        hstr.Visible = 'on';
    end
 
end
